/*
 * Decompiled with CFR 0.152.
 */
package org.h14199.util.geometry;

import java.io.ByteArrayOutputStream;
import java.lang.reflect.Method;
import org.h14199.message.DbException;
import org.h14199.util.geometry.EWKBUtils;
import org.h14199.util.geometry.GeometryUtils;
import org.locationtech.jts.geom.CoordinateSequence;
import org.locationtech.jts.geom.CoordinateSequenceFactory;
import org.locationtech.jts.geom.Geometry;
import org.locationtech.jts.geom.GeometryCollection;
import org.locationtech.jts.geom.GeometryFactory;
import org.locationtech.jts.geom.LineString;
import org.locationtech.jts.geom.LinearRing;
import org.locationtech.jts.geom.MultiLineString;
import org.locationtech.jts.geom.MultiPoint;
import org.locationtech.jts.geom.MultiPolygon;
import org.locationtech.jts.geom.Point;
import org.locationtech.jts.geom.Polygon;
import org.locationtech.jts.geom.PrecisionModel;
import org.locationtech.jts.geom.impl.CoordinateArraySequenceFactory;
import org.locationtech.jts.geom.impl.PackedCoordinateSequenceFactory;

public final class JTSUtils {
    public static final boolean M_IS_SUPPORTED;
    static final Method CREATE;
    private static final Method GET_MEASURES;

    public static Geometry ewkb2geometry(byte[] byArray) {
        GeometryUtils.DimensionSystemTarget dimensionSystemTarget = new GeometryUtils.DimensionSystemTarget();
        EWKBUtils.parseEWKB(byArray, dimensionSystemTarget);
        return JTSUtils.ewkb2geometry(byArray, dimensionSystemTarget.getDimensionSystem());
    }

    public static Geometry ewkb2geometry(byte[] byArray, int n) {
        GeometryTarget geometryTarget = new GeometryTarget(n);
        EWKBUtils.parseEWKB(byArray, geometryTarget);
        return geometryTarget.getGeometry();
    }

    public static byte[] geometry2ewkb(Geometry geometry) {
        GeometryUtils.DimensionSystemTarget dimensionSystemTarget = new GeometryUtils.DimensionSystemTarget();
        JTSUtils.parseGeometry(geometry, dimensionSystemTarget);
        return JTSUtils.geometry2ewkb(geometry, dimensionSystemTarget.getDimensionSystem());
    }

    public static byte[] geometry2ewkb(Geometry geometry, int n) {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        EWKBUtils.EWKBTarget eWKBTarget = new EWKBUtils.EWKBTarget(byteArrayOutputStream, n);
        JTSUtils.parseGeometry(geometry, eWKBTarget);
        return byteArrayOutputStream.toByteArray();
    }

    public static void parseGeometry(Geometry geometry, GeometryUtils.Target target) {
        JTSUtils.parseGeometry(geometry, target, 0);
    }

    private static void parseGeometry(Geometry geometry, GeometryUtils.Target target, int n) {
        if (n == 0) {
            target.init(geometry.getSRID());
        }
        if (geometry instanceof Point) {
            if (n != 0 && n != 4 && n != 7) {
                throw new IllegalArgumentException();
            }
            target.startPoint();
            Point point = (Point)geometry;
            if (point.isEmpty()) {
                target.addCoordinate(Double.NaN, Double.NaN, Double.NaN, Double.NaN, 0, 1);
            } else {
                CoordinateSequence coordinateSequence = point.getCoordinateSequence();
                JTSUtils.addCoordinate(coordinateSequence, target, 0, 1, JTSUtils.getMeasures(coordinateSequence));
            }
        } else if (geometry instanceof LineString) {
            if (n != 0 && n != 5 && n != 7) {
                throw new IllegalArgumentException();
            }
            LineString lineString = (LineString)geometry;
            CoordinateSequence coordinateSequence = lineString.getCoordinateSequence();
            int n2 = coordinateSequence.size();
            if (n2 < 0 || n2 == 1) {
                throw new IllegalArgumentException();
            }
            target.startLineString(n2);
            int n3 = JTSUtils.getMeasures(coordinateSequence);
            for (int i = 0; i < n2; ++i) {
                JTSUtils.addCoordinate(coordinateSequence, target, i, n2, n3);
            }
        } else if (geometry instanceof Polygon) {
            if (n != 0 && n != 6 && n != 7) {
                throw new IllegalArgumentException();
            }
            Polygon polygon = (Polygon)geometry;
            int n4 = polygon.getNumInteriorRing();
            if (n4 < 0) {
                throw new IllegalArgumentException();
            }
            CoordinateSequence coordinateSequence = polygon.getExteriorRing().getCoordinateSequence();
            int n5 = coordinateSequence.size();
            if (n5 < 0 || n5 >= 1 && n5 <= 3) {
                throw new IllegalArgumentException();
            }
            if (n5 == 0 && n4 > 0) {
                throw new IllegalArgumentException();
            }
            target.startPolygon(n4, n5);
            if (n5 > 0) {
                int n6 = JTSUtils.getMeasures(coordinateSequence);
                JTSUtils.addRing(coordinateSequence, target, n5, n6);
                for (int i = 0; i < n4; ++i) {
                    coordinateSequence = polygon.getInteriorRingN(i).getCoordinateSequence();
                    n5 = coordinateSequence.size();
                    if (n5 < 0 || n5 >= 1 && n5 <= 3) {
                        throw new IllegalArgumentException();
                    }
                    target.startPolygonInner(n5);
                    JTSUtils.addRing(coordinateSequence, target, n5, n6);
                }
                target.endNonEmptyPolygon();
            }
        } else if (geometry instanceof GeometryCollection) {
            if (n != 0 && n != 7) {
                throw new IllegalArgumentException();
            }
            GeometryCollection geometryCollection = (GeometryCollection)geometry;
            int n7 = geometryCollection instanceof MultiPoint ? 4 : (geometryCollection instanceof MultiLineString ? 5 : (geometryCollection instanceof MultiPolygon ? 6 : 7));
            int n8 = geometryCollection.getNumGeometries();
            if (n8 < 0) {
                throw new IllegalArgumentException();
            }
            target.startCollection(n7, n8);
            for (int i = 0; i < n8; ++i) {
                GeometryUtils.Target target2 = target.startCollectionItem(i, n8);
                JTSUtils.parseGeometry(geometryCollection.getGeometryN(i), target2, n7);
                target.endCollectionItem(target2, i, n8);
            }
            target.endCollection(n7);
        } else {
            throw new IllegalArgumentException();
        }
    }

    private static void addRing(CoordinateSequence coordinateSequence, GeometryUtils.Target target, int n, int n2) {
        if (n >= 4) {
            double d = GeometryUtils.toCanonicalDouble(coordinateSequence.getX(0));
            double d2 = GeometryUtils.toCanonicalDouble(coordinateSequence.getY(0));
            JTSUtils.addCoordinate(coordinateSequence, target, 0, n, d, d2, n2);
            for (int i = 1; i < n - 1; ++i) {
                JTSUtils.addCoordinate(coordinateSequence, target, i, n, n2);
            }
            double d3 = GeometryUtils.toCanonicalDouble(coordinateSequence.getX(n - 1));
            double d4 = GeometryUtils.toCanonicalDouble(coordinateSequence.getY(n - 1));
            if (d != d3 || d2 != d4) {
                throw new IllegalArgumentException();
            }
            JTSUtils.addCoordinate(coordinateSequence, target, n - 1, n, d3, d4, n2);
        }
    }

    private static void addCoordinate(CoordinateSequence coordinateSequence, GeometryUtils.Target target, int n, int n2, int n3) {
        JTSUtils.addCoordinate(coordinateSequence, target, n, n2, GeometryUtils.toCanonicalDouble(coordinateSequence.getX(n)), GeometryUtils.toCanonicalDouble(coordinateSequence.getY(n)), n3);
    }

    private static void addCoordinate(CoordinateSequence coordinateSequence, GeometryUtils.Target target, int n, int n2, double d, double d2, int n3) {
        double d3;
        double d4;
        int n4 = coordinateSequence.getDimension();
        if (M_IS_SUPPORTED) {
            d4 = (n4 -= n3) > 2 ? GeometryUtils.toCanonicalDouble(coordinateSequence.getOrdinate(n, 2)) : Double.NaN;
            d3 = n3 >= 1 ? GeometryUtils.toCanonicalDouble(coordinateSequence.getOrdinate(n, n4)) : Double.NaN;
        } else {
            d4 = n4 >= 3 ? GeometryUtils.toCanonicalDouble(coordinateSequence.getOrdinate(n, 2)) : Double.NaN;
            d3 = n4 >= 4 ? GeometryUtils.toCanonicalDouble(coordinateSequence.getOrdinate(n, 3)) : Double.NaN;
        }
        target.addCoordinate(d, d2, d4, d3, n, n2);
    }

    private static int getMeasures(CoordinateSequence coordinateSequence) {
        int n;
        if (M_IS_SUPPORTED) {
            try {
                n = (Integer)GET_MEASURES.invoke((Object)coordinateSequence, new Object[0]);
            }
            catch (ReflectiveOperationException reflectiveOperationException) {
                throw DbException.convert(reflectiveOperationException);
            }
        } else {
            n = 0;
        }
        return n;
    }

    private JTSUtils() {
    }

    static {
        Method method;
        Method method2;
        try {
            method2 = CoordinateSequenceFactory.class.getMethod("create", Integer.TYPE, Integer.TYPE, Integer.TYPE);
            method = CoordinateSequence.class.getMethod("getMeasures", new Class[0]);
        }
        catch (ReflectiveOperationException reflectiveOperationException) {
            method2 = null;
            method = null;
        }
        M_IS_SUPPORTED = method2 != null;
        CREATE = method2;
        GET_MEASURES = method;
    }

    public static final class GeometryTarget
    extends GeometryUtils.Target {
        private final int dimensionSystem;
        private GeometryFactory factory;
        private int type;
        private CoordinateSequence coordinates;
        private CoordinateSequence[] innerCoordinates;
        private int innerOffset;
        private Geometry[] subgeometries;

        public GeometryTarget(int n) {
            this.dimensionSystem = n;
        }

        private GeometryTarget(int n, GeometryFactory geometryFactory) {
            this.dimensionSystem = n;
            this.factory = geometryFactory;
        }

        @Override
        protected void init(int n) {
            this.factory = new GeometryFactory(new PrecisionModel(), n, (CoordinateSequenceFactory)((this.dimensionSystem & 2) != 0 ? PackedCoordinateSequenceFactory.DOUBLE_FACTORY : CoordinateArraySequenceFactory.instance()));
        }

        @Override
        protected void startPoint() {
            this.type = 1;
            this.initCoordinates(1);
            this.innerOffset = -1;
        }

        @Override
        protected void startLineString(int n) {
            this.type = 2;
            this.initCoordinates(n);
            this.innerOffset = -1;
        }

        @Override
        protected void startPolygon(int n, int n2) {
            this.type = 3;
            this.initCoordinates(n2);
            this.innerCoordinates = new CoordinateSequence[n];
            this.innerOffset = -1;
        }

        @Override
        protected void startPolygonInner(int n) {
            this.innerCoordinates[++this.innerOffset] = this.createCoordinates(n);
        }

        @Override
        protected void startCollection(int n, int n2) {
            this.type = n;
            switch (n) {
                case 4: {
                    this.subgeometries = new Point[n2];
                    break;
                }
                case 5: {
                    this.subgeometries = new LineString[n2];
                    break;
                }
                case 6: {
                    this.subgeometries = new Polygon[n2];
                    break;
                }
                case 7: {
                    this.subgeometries = new Geometry[n2];
                    break;
                }
                default: {
                    throw new IllegalArgumentException();
                }
            }
        }

        @Override
        protected GeometryUtils.Target startCollectionItem(int n, int n2) {
            return new GeometryTarget(this.dimensionSystem, this.factory);
        }

        @Override
        protected void endCollectionItem(GeometryUtils.Target target, int n, int n2) {
            this.subgeometries[n] = ((GeometryTarget)target).getGeometry();
        }

        private void initCoordinates(int n) {
            this.coordinates = this.createCoordinates(n);
        }

        private CoordinateSequence createCoordinates(int n) {
            if ((this.dimensionSystem & 2) != 0) {
                if (M_IS_SUPPORTED) {
                    try {
                        return (CoordinateSequence)CREATE.invoke((Object)this.factory.getCoordinateSequenceFactory(), n, 4, 1);
                    }
                    catch (ReflectiveOperationException reflectiveOperationException) {
                        throw DbException.convert(reflectiveOperationException);
                    }
                }
                return this.factory.getCoordinateSequenceFactory().create(n, 4);
            }
            return this.factory.getCoordinateSequenceFactory().create(n, 3);
        }

        @Override
        protected void addCoordinate(double d, double d2, double d3, double d4, int n, int n2) {
            if (this.type == 1 && Double.isNaN(d) && Double.isNaN(d2) && Double.isNaN(d3) && Double.isNaN(d4)) {
                this.coordinates = this.createCoordinates(0);
                return;
            }
            CoordinateSequence coordinateSequence = this.innerOffset < 0 ? this.coordinates : this.innerCoordinates[this.innerOffset];
            coordinateSequence.setOrdinate(n, 0, GeometryUtils.checkFinite(d));
            coordinateSequence.setOrdinate(n, 1, GeometryUtils.checkFinite(d2));
            coordinateSequence.setOrdinate(n, 2, (this.dimensionSystem & 1) != 0 ? GeometryUtils.checkFinite(d3) : Double.NaN);
            if ((this.dimensionSystem & 2) != 0) {
                coordinateSequence.setOrdinate(n, 3, GeometryUtils.checkFinite(d4));
            }
        }

        Geometry getGeometry() {
            switch (this.type) {
                case 1: {
                    return new Point(this.coordinates, this.factory);
                }
                case 2: {
                    return new LineString(this.coordinates, this.factory);
                }
                case 3: {
                    LinearRing linearRing = new LinearRing(this.coordinates, this.factory);
                    int n = this.innerCoordinates.length;
                    LinearRing[] linearRingArray = new LinearRing[n];
                    for (int i = 0; i < n; ++i) {
                        linearRingArray[i] = new LinearRing(this.innerCoordinates[i], this.factory);
                    }
                    return new Polygon(linearRing, linearRingArray, this.factory);
                }
                case 4: {
                    return new MultiPoint((Point[])this.subgeometries, this.factory);
                }
                case 5: {
                    return new MultiLineString((LineString[])this.subgeometries, this.factory);
                }
                case 6: {
                    return new MultiPolygon((Polygon[])this.subgeometries, this.factory);
                }
                case 7: {
                    return new GeometryCollection(this.subgeometries, this.factory);
                }
            }
            throw new IllegalStateException();
        }
    }
}

